/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep;

import com.ibm.hsc.rep.RClassSchema;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RUtils;
import com.ibm.hsc.rep.serialization.RSerializableInterface;
import com.ibm.hsc.rep.serialization.RSerializableObject;
import com.ibm.hsc.rep.serialization.RSerializableProperty;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;

public class RObjectId
implements RSerializableInterface,
Cloneable {
    private int nameSpaceId;
    private int classId;
    private Object[] key;
    private int numOfKeys;

    public RObjectId() {
    }

    public RObjectId(int n, int n2) throws RException {
        this.classId = n2;
        this.nameSpaceId = n;
        this.numOfKeys = RUtils.getClassSchema(this.nameSpaceId, this.classId).getNumOfKeys();
        this.key = new Object[this.numOfKeys];
    }

    public RObjectId(CIMObjectPath cIMObjectPath) throws RException {
        String string = cIMObjectPath.getNameSpace();
        this.nameSpaceId = RUtils.getNameSpaceId(string);
        this.classId = RUtils.getClassId(this.nameSpaceId, cIMObjectPath.getObjectName());
        RClassSchema rClassSchema = RUtils.getClassSchema(this.nameSpaceId, this.classId);
        this.numOfKeys = rClassSchema.getNumOfKeys();
        this.key = new Object[this.numOfKeys];
        Vector vector = cIMObjectPath.getKeys();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                int n = rClassSchema.getIndex(cIMProperty.getName());
                int n2 = rClassSchema.getKeyIndex(n);
                this.key[n2] = cIMProperty.getValue().getValue();
            }
        }
    }

    public void loadObject(RSerializableObject rSerializableObject) throws ObjectStreamException {
        try {
            Vector vector = (Vector)rSerializableObject.getObject();
            int n = vector.size();
            this.nameSpaceId = RUtils.getNameSpaceId((String)vector.elementAt(0));
            this.classId = RUtils.getClassId(this.nameSpaceId, (String)vector.elementAt(1));
            this.numOfKeys = RUtils.getClassSchema(this.nameSpaceId, this.classId).getNumOfKeys();
            this.key = new Object[this.numOfKeys];
            RClassSchema rClassSchema = RUtils.getClassSchema(this.nameSpaceId, this.classId);
            for (int i = 2; i < n; ++i) {
                RSerializableProperty rSerializableProperty = (RSerializableProperty)vector.elementAt(i);
                int n2 = rClassSchema.getIndex(rSerializableProperty.getName());
                int n3 = rClassSchema.getKeyIndex(n2);
                if (n3 < 0 || n3 >= this.numOfKeys) continue;
                this.key[n3] = rSerializableProperty.getRValue();
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new InvalidObjectException(rException.getID());
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        try {
            String string = "com.ibm.hsc.rep.client.RClientObjectId";
            Vector<Object> vector = new Vector<Object>();
            vector.add(RUtils.getNameSpaceString(this.nameSpaceId));
            RClassSchema rClassSchema = RUtils.getClassSchema(this.nameSpaceId, this.classId);
            vector.add(rClassSchema.getClassName());
            for (int i = 0; i < this.numOfKeys; ++i) {
                RSerializableProperty rSerializableProperty = new RSerializableProperty(true, rClassSchema.getPropName(rClassSchema.getKeyPos(i)), this.key[i]);
                vector.add(rSerializableProperty);
            }
            RSerializableObject rSerializableObject = new RSerializableObject(string, null, vector);
            return rSerializableObject;
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new InvalidObjectException(rException.getID());
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        RObjectId rObjectId = (RObjectId)object;
        rObjectId.key = (Object[])this.key.clone();
        for (int i = 0; i < this.key.length; ++i) {
            if (this.key[i] == null) continue;
            if (this.key[i] instanceof Vector) {
                rObjectId.key[i] = ((Vector)this.key[i]).clone();
                continue;
            }
            Class<?> clazz = this.key[i].getClass();
            if (!clazz.isArray()) continue;
            rObjectId.key[i] = ((Object[])this.key[i]).clone();
        }
        return rObjectId;
    }

    public int getNameSpaceId() {
        return this.nameSpaceId;
    }

    public int getClassId() {
        return this.classId;
    }

    public int getNumOfKeys() {
        return this.numOfKeys;
    }

    public void setKeyValue(int n, Object object) {
        this.key[n] = object;
    }

    public Object getKeyValue(int n) {
        return this.key[n];
    }

    public RObject getObject() throws RException {
        RClassSchema rClassSchema = RUtils.getClassSchema(this.nameSpaceId, this.classId);
        RObject rObject = (RObject)rClassSchema.getObjHash().get(this);
        return rObject;
    }

    public boolean equals(Object object) {
        RObjectId rObjectId = (RObjectId)object;
        if (this.nameSpaceId != rObjectId.nameSpaceId) {
            return false;
        }
        if (this.classId != rObjectId.classId) {
            return false;
        }
        if (this.numOfKeys != rObjectId.numOfKeys) {
            return false;
        }
        for (int i = 0; i < this.numOfKeys; ++i) {
            if (this.key[i].equals(rObjectId.key[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.nameSpaceId);
        stringBuffer.append("%");
        stringBuffer.append(this.classId);
        for (int i = 0; i < this.numOfKeys; ++i) {
            stringBuffer.append("%");
            stringBuffer.append(this.key[i].toString());
        }
        return stringBuffer.toString().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            RClassSchema rClassSchema = RUtils.getClassSchema(this.nameSpaceId, this.classId);
            stringBuffer.append(rClassSchema.getClassName());
            stringBuffer.append(".");
            for (int i = 0; i < this.numOfKeys; ++i) {
                int n = rClassSchema.getKeyPos(i);
                String string = rClassSchema.getPropName(n);
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(this.key[i]);
                if (i >= this.numOfKeys - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(";");
        }
        catch (RException rException) {
            rException.printStackTrace();
        }
        return stringBuffer.toString();
    }
}

